#### AllSeasons: Table C1 summarise simulated mean WTP  ###############
# Script author: Peter King (p.king1@leeds.ac.uk)
# Function: Stitch mean (lowest - highest) for attribute, level, season
# Last Edited: 16/10/2025
# Changes:
## - Thank you Gemini and Claude for optimising the PlotData code


# *******************************************************************
#### Section 0: Setup and estimate models ####
# *******************************************************************

# install.packages("data.table",repos="http://cran.us.r-project.org")
# options(scipen=90)
library(apollo)
library(tidyverse)
library(mded)
library(here)
library(data.table)
library(Rfast)


# *******************************************************************
#### Section 1: Import Data  ####
# *******************************************************************


WTP_All <- here("CEOutputData/H3",
                "SimulatedMeans_Correlated.csv") %>%
  fread() %>% data.frame()


WTP_Pooled <- here("CEOutputData/H3",
                   "AllSeasons_Correlated.csv") %>%
  fread() %>% data.frame()


# *******************************************************************
#### Section 2A: Manipulate Data  ####
# *******************************************************************

WTP_Combined <-  rbind(
  bind_cols(
    "ColourHigh" = WTP_All$Colour2,
    "ColourMedium" = WTP_All$Colour,
    "SmellHigh" = WTP_All$Smell2,
    "SmellMedium" = WTP_All$Smell,
    "SoundHigh" = WTP_All$Sound2,
    "SoundMedium" = WTP_All$Sound,
    "DeadwoodHigh" = WTP_All$Deadwood2,
    "DeadwoodMedium" = WTP_All$Deadwood,
    "Season" =  WTP_All$Season
  ),


  bind_cols(
    "ColourHigh" = WTP_Pooled$Colour2,
    "ColourMedium" = WTP_Pooled$Colour,
    "SmellHigh" = WTP_Pooled$Smell2,
    "SmellMedium" = WTP_Pooled$Smell,
    "SoundHigh" = WTP_Pooled$Sound2,
    "SoundMedium" = WTP_Pooled$Sound,
    "DeadwoodHigh" = WTP_Pooled$Deadwood2,
    "DeadwoodMedium" = WTP_Pooled$Deadwood,
    "Season" =  4
  )
)

# *******************************************************************
#### Section 2B: Setup table  ####
# *******************************************************************


PlotData <- WTP_Combined %>%
  pivot_longer(cols = 1:8,
               names_to = c("Variable", "Level"),
               names_sep = "(?<=[a-z])(?=[A-Z])",
               values_to = "value") %>%
  group_by(Variable, Level, Season) %>%
  summarise(
    range = {
      q <- quantile(value, probs = c(0.025, 0.5, 0.975)) ## 95% CI and median
      sprintf("%.2f (%.2f- %.2f)", q[2], q[1], q[3])
    },
    .groups = "drop"
  ) %>%
  pivot_wider(names_from = Season, values_from = range) %>%
  # A) Change "Variable" order
  mutate(Variable = factor(Variable,
                           levels = c("Colour",
                                      "Smell",
                                      "Sound",
                                      "Deadwood"))) %>%
  arrange(Variable, Level)


# *******************************************************************
#### Section 3: Export  ####
# *******************************************************************


TableC1 <- PlotData

## Use paste0 and here to store in the right location
TableC1 %>% fwrite(sep = ",",
                    quote = FALSE,
                    paste0(here(
                      "OtherOutput/Tables",
                      "TableC1_H3_WTPsummary_Correlated.txt"
                    )))



